  'Project: Dual Mode Digital Dice
'Bascom-Avr IDE [2.0.7.5]
'Flash used 2112 Bytes
'Author: Mahmood Alimohammadi
'Date: August 14 , 2018
'-------------------------------------------
$crystal = 4000000

Config Lcd = 16 * 2
Config Lcdpin = Pin , Db4 = Portd.0 , Db5 = Portd.1 , Db6 = Portd.2 , Db7 = Portd.3 , E = Portd.4 , Rs = Portd.5

Config Timer0 = Timer , Prescale = 8

Config Portc.1 = Input : Portc.1 = 1 : Modes Alias Pinc.1
Config Portc.2 = Input : Portc.2 = 1 : Starts Alias Pinc.2
Config Portc.3 = Output : Speaker Alias Portc.3

'-------------------------------------------
Dim Dice As Byte , Random1 As Byte , Random2 As Byte , Roll As Byte , Patterns As Bit
Dim ___rseed As Word

'-------------------------------------------

Deflcdchar 1 , 32 , 31 , 31 , 31 , 27 , 31 , 31 , 31
Deflcdchar 2 , 32 , 31 , 29 , 31 , 31 , 31 , 23 , 31
Deflcdchar 3 , 32 , 31 , 29 , 31 , 27 , 31 , 23 , 31
Deflcdchar 4 , 32 , 31 , 21 , 31 , 31 , 31 , 21 , 31
Deflcdchar 5 , 32 , 31 , 21 , 31 , 27 , 31 , 21 , 31
Deflcdchar 6 , 32 , 31 , 21 , 31 , 21 , 31 , 21 , 31

'-------------------------------------------
Cls
Cursor Off
'-------------------------------------------

Locate 1 , 1 : Lcd "Digital Dice"

For Roll = 1 To 6

Locate 1 , 16 : Lcd Chr(roll)
Locate 2 , 16 : Lcd Chr(roll)

Sound Speaker , 150 , 150
Waitms 500

Next
Cls
Upperline
Lcd "Digital Dice"

'-------------------------------------------
'Start the game when play button is pressed and choose the mode to play.

Begin:

Do
If Modes = 0 Then
Waitms 250

Toggle Patterns
End If

If Patterns = 0 Then
Locate 2 , 11
Lcd "Mode 1"
Else
Locate 2 , 11
Lcd "Mode 2"
End If

'Assign ___RSEED with the timer0 value.
'This will give a better random number.
___rseed = Timer0

Loop Until Starts = 0

'-------------------------------------------

Do

If Starts = 0 Then

'Simulate the rolling of dice in six steps.

For Roll = 1 To 6
Random1 = Rnd(7)
Random2 = Rnd(7)

If Patterns = 0 Then
Gosub Mode1
Else
Gosub Mode2
End If

'Simulate the sound of the rolling dice in six steps.
Sound Speaker , 100 , 100

Next
'-------------------------------------------
'Display the result and return to the begin.
Do

If Patterns = 0 Then

Gosub Mode1
Goto Begin

Else
Gosub Mode2
Goto Begin

End If
Loop

End If
Loop

End
'-------------------------------------------
Mode1:

Cls
Locate 2 , 11
Lcd "Mode 1"

Select Case Random1

Case 0 : Locate 1 , 1
Lcd Chr(1) ; " 1"

Case 1 : Locate 1 , 1

Lcd Chr(1) ; " 1"

Case 2 : Locate 1 , 2

Lcd Chr(2) ; " 2"

Case 3 : Locate 1 , 3

Lcd Chr(3) ; " 3"

Case 4 : Locate 1 , 4

Lcd Chr(4) ; " 4"

Case 5 : Locate 1 , 5

Lcd Chr(5) ; " 5"

Case 6 : Locate 1 , 6

Lcd Chr(6) ; " 6"
End Select
'-------------------------------------------

Select Case Random2

Case 0 : Locate 2 , 6
Lcd Chr(6) ; " 6"

Case 1 : Locate 2 , 1
Lcd Chr(1) ; " 1"

Case 2 : Locate 2 , 2
Lcd Chr(2) ; " 2"

Case 3 : Locate 2 , 3
Lcd Chr(3) ; " 3"

Case 4 : Locate 2 , 4
Lcd Chr(4) ; " 4"

Case 5 : Locate 2 , 5
Lcd Chr(5) ; " 5"

Case 6 : Locate 2 , 6
Lcd Chr(6) ; " 6"

End Select

Waitms 150

Return
'-------------------------------------------

Mode2:

Cls
Locate 2 , 11
Lcd "Mode 2"

Select Case Random1

Case 0 : Upperline
Lcd Chr(1) ; " 1"



Case 1 : Upperline
Lcd Chr(1) ; " 1"

Case 2 : Upperline
Lcd Chr(1)
Lcd Chr(2) ; " 2"

Case 3 : Upperline
Lcd Chr(1)
Lcd Chr(2)
Lcd Chr(3) ; " 3"


Case 4 : Upperline
Lcd Chr(1)
Lcd Chr(2)
Lcd Chr(3)
Lcd Chr(4) ; " 4"

Case 5 : Upperline
Lcd Chr(1)
Lcd Chr(2)
Lcd Chr(3)
Lcd Chr(4)
Lcd Chr(5) ; " 5"

Case 6 : Upperline
Lcd Chr(1)
Lcd Chr(2)
Lcd Chr(3)
Lcd Chr(4)
Lcd Chr(5)
Lcd Chr(6) ; " 6"

End Select

Select Case Random2

Case 0 : Lowerline
Lcd Chr(1)
Lcd Chr(2)
Lcd Chr(3)
Lcd Chr(4)
Lcd Chr(5)
Lcd Chr(6) ; " 6"

Case 1 : Lowerline
Lcd Chr(1) ; " 1"

Case 2 : Lowerline
Lcd Chr(1)
Lcd Chr(2) ; " 2"

Case 3 : Lowerline
Lcd Chr(1)
Lcd Chr(2)
Lcd Chr(3) ; " 3"

Case 4 : Lowerline
Lcd Chr(1)
Lcd Chr(2)
Lcd Chr(3)
Lcd Chr(4) ; " 4"

Case 5 : Lowerline
Lcd Chr(1)
Lcd Chr(2)
Lcd Chr(3)
Lcd Chr(4)
Lcd Chr(5) ; " 5"

Case 6 : Lowerline
Lcd Chr(1)
Lcd Chr(2)
Lcd Chr(3)
Lcd Chr(4)
Lcd Chr(5)
Lcd Chr(6) ; " 6"
End Select

Waitms 150

Return
'End of program

'-------------